// VERSION: Scilab: 5.4.1 
// OS: windows 7 
//CAPTION: PROGRAM TO COMPUTE BLOCK CONVOLUTION USINF OVERLAP SAVE METHOD
clc;
clear;
close;
x=input('Enter the input sequence=') //x=[1 2 -1 2 3 -2 -3 -1 1 1 2 -1]
m=length(x);
xl=input('Enter the lower index of input sequence=')//0
xh=xl+m-1;
n=xl:1:xh;
subplot(3,1,1);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,x);
title('Input Sequence x[n]');
xlabel('Samples n');
ylabel('Amplitude');

h=input('Enter the impulse response sequence=');//h=[1 2 3 -1]
l=length(h);
hl=input('Enter the lower index of impulse response sequence=');//0
hh=hl+l-1;
g=hl:1:hh;
subplot(3,1,2);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',g,h);
title('Impulse Response Sequence h[n]');
xlabel('Samples n');
ylabel('Amplitude');

N=m+l-1;
h1=[h zeros(1,N-m)];
n3=length(h1);
y=zeros(1,N);
x1=[zeros(1,n3-l) x zeros(1,n3)];
H=fft(h1);
for i=1:l:N
    y1=x1(i:i+(2*(n3-l)));
    y2=fft(y1);
    y3=y2.*H;
    y4=round(ifft(y3));
    y(i:(i+n3-l))=y4(l:n3);
end
disp('Output sequence using overlap save method Y(n):');
disp(y(1:N));
nx=xl+hl;
r=nx:length(y)-1;
subplot(3,1,3);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',r,y);
title('Output sequence using Overlap save method y[n]');
xlabel('Samples n');
ylabel('Amplitude');

//INPUT:
//Enter the input sequence=[1 2 -1 2 3 -2 -3 -1 1 1 2 -1]
//Enter the lower index of input sequence=0
//Enter the impulse response sequence=[1 2 3 -1]
//Enter the lower index of impulse response sequence=0
 
 //OUTPUT:
 //Output sequence using overlap save method Y(n):   
 
 
   //      column  1 to 12
 
   // 1.    4.    6.    5.    2.    11.    0.  - 16.  - 8.    3.    8.    5.  
 
     //    column 13 to 15
 
   // 3.  - 5.    1.  
